/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.commands.commands;

import Krasnodar.rockstarnew.systems.commands.Command;
import Krasnodar.rockstarnew.systems.commands.CommandBuilder;
import Krasnodar.rockstarnew.systems.commands.CommandContext;
import Krasnodar.rockstarnew.systems.commands.ValidationResult;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import ru.kotopushka.compiler.sdk.annotations.Compile;

public class InventoryCommand
implements IMinecraft {
    private final Map<String, Map<Integer, Integer>> inventories = new HashMap<String, Map<Integer, Integer>>();

    @Compile
    public Command command() {
        return CommandBuilder.begin("inv").aliases("inventory", "slot", "\u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c").desc("commands.inventory.description").param("action", p -> p.literal("save", "create", "add", "\u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "load", "use", "\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c")).param("name", p -> p.optional().validator(text -> (ValidationResult)((Object)(text.length() < 2 ? ValidationResult.error("commands.prefix.invalid_length") : ValidationResult.ok(text))))).handler(this::handle).build();
    }

    @Compile
    private void handle(CommandContext ctx) {
        String action = (String)ctx.arguments().get(0);
        String name = (String)ctx.arguments().get(1);
        if (action.equals("save") || action.equals("create") || action.equals("add") || action.equals("\u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c")) {
            this.saveInventory(name);
            MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.inventory.saved", name)));
        } else if (!(action.equals("load") || action.equals("use") || action.equals("\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c"))) {
            MessageUtility.error(class_2561.method_30163((String)Localizator.translate("commands.inventory.invalid_action")));
        } else {
            this.loadInventory(name);
        }
    }

    @Compile
    private void saveInventory(String name) {
        if (InventoryCommand.mc.field_1724 != null) {
            HashMap<Integer, Integer> inventory = new HashMap<Integer, Integer>();
            for (int i = 0; i <= 45; ++i) {
                class_1799 stack = InventoryCommand.mc.field_1724.field_7512.method_7611(i).method_7677();
                if (stack.method_7960()) continue;
                inventory.put(i, class_1792.method_7880((class_1792)stack.method_7909()));
            }
            this.inventories.put(name, inventory);
        }
    }

    private void loadInventory(String name) {
        if (!this.inventories.containsKey(name)) {
            MessageUtility.error(class_2561.method_30163((String)Localizator.translate("commands.inventory.not_found", name)));
        } else {
            Map<Integer, Integer> savedInventory = this.inventories.get(name);
            boolean anyItemRendered = false;
            for (Map.Entry<Integer, Integer> entry : savedInventory.entrySet()) {
                int slotIndex = entry.getKey();
                class_1792 item = class_1792.method_7875((int)entry.getValue());
                class_1799 ghostStack = new class_1799((class_1935)item);
                ghostStack.method_7939(1);
                InventoryCommand.mc.field_1724.field_7512.method_7611(slotIndex).method_53512(ghostStack);
                anyItemRendered = true;
            }
            if (anyItemRendered) {
                MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.inventory.loaded")));
            } else {
                MessageUtility.error(class_2561.method_30163((String)Localizator.translate("commands.inventory.empty")));
            }
        }
    }

    @Compile
    public JsonObject save() {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, Map<Integer, Integer>> entry : this.inventories.entrySet()) {
            JsonObject innerJson = new JsonObject();
            for (Map.Entry<Integer, Integer> innerEntry : entry.getValue().entrySet()) {
                innerJson.addProperty(innerEntry.getKey().toString(), (Number)innerEntry.getValue());
            }
            jsonObject.add(entry.getKey(), (JsonElement)innerJson);
        }
        return jsonObject;
    }

    @Compile
    public void load(JsonElement jsonElement) {
        this.inventories.clear();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonObject innerJson = ((JsonElement)entry.getValue()).getAsJsonObject();
            HashMap<Integer, Integer> innerMap = new HashMap<Integer, Integer>();
            for (Map.Entry innerEntry : innerJson.entrySet()) {
                Integer intKey = Integer.valueOf((String)innerEntry.getKey());
                Integer value = ((JsonElement)innerEntry.getValue()).getAsInt();
                innerMap.put(intKey, value);
            }
            this.inventories.put((String)entry.getKey(), innerMap);
        }
    }
}

